<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Ding;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method continueToMakeUpByParams(array $params)
 * @method getMakeUpAssistantsByParams(array $params)
 * @method completeMakeUpByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\CompleteProcessCmd $params)
 * @method setAssistMakeUpNumByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\AssistMakeUpNumCmd $params)
 * @method completePhotographyByParams(array $params)
 * @method completeAndHangByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\CompleteProcessCmd $params)
 * @method goSelectPhotoByParams(array $params)
 * @method assignAssistanceByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\AssignAssistanceCmd $params)
 * @method orderAgainByParams(array $params)
 * @method saveNoteByParams(array $params)
 */
class ProcessDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 主化妆师继续化妆
     *
     * @support  int $processId 流程ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function continueToMakeUp () {
        return self::getClass()->continueToMakeUp([
        ]);
    }

    /**
     * 获取多产品协作信息
     *
     * @support  int $processId 流程id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\ProcessDresserDTO[]
     */
    public static function getMakeUpAssistants () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMakeUpAssistants([
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\ProcessDresserDTO[]"
        );
    }

    /**
     * 完成化妆
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\CompleteProcessCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function completeMakeUp (\Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\CompleteProcessCmd $cmd) {
        return self::getClass()->completeMakeUp($cmd);
    }


    /**
     * 修改妆面数量
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\AssistMakeUpNumCmd $assistMakeUpNumCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function setAssistMakeUpNum (\Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\AssistMakeUpNumCmd $assistMakeUpNumCmd) {
        return self::getClass()->setAssistMakeUpNum($assistMakeUpNumCmd);
    }


    /**
     * 完成摄影
     *
     * @support  int $processId 流程ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function completePhotography () {
        return self::getClass()->completePhotography([
        ]);
    }

    /**
     * 完成并挂起
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\CompleteProcessCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function completeAndHang (\Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\CompleteProcessCmd $cmd) {
        return self::getClass()->completeAndHang($cmd);
    }


    /**
     * 完成摄影去选片
     *
     * @support  int $processId 流程ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function goSelectPhoto () {
        return self::getClass()->goSelectPhoto([
        ]);
    }

    /**
     * 指派协作化妆师
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\AssignAssistanceCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function assignAssistance (\Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\AssignAssistanceCmd $cmd) {
        return self::getClass()->assignAssistance($cmd);
    }


    /**
     * 再来一单
     *
     * @support  int $orderId 订单ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderAgain () {
        return self::getClass()->orderAgain([
        ]);
    }

    /**
     * 更新流程备注信息
     *
     * @support  int $processId 流程ID [ require false ]
     * @support  string $note 备注 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveNote () {
        return self::getClass()->saveNote([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Ding\ProcessDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Ding\ProcessDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}