<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage\Paperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreStaffsByParams(array $params)
 * @method getWorkStatesByParams(array $params)
 * @method getAvailableStaffIdsByParams(array $params)
 * @method getCurrentHangStaffsByParams(array $params)
 * @method getHangTimeoutStaffsByParams(array $params)
 */
class StoreStaff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据伙伴类型获取成员列表
     *
     * @support  string $staffType 伙伴类型 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreStaffs () {
        return self::getClass()->getStoreStaffs([
        ]);
    }

    /**
     * 获取伙伴工作状态
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getWorkStates () {
        return self::getClass()->getWorkStates();
    }

    /**
     * 过滤已通关伙伴列表
     *
     * @support  int $orderId 订单号 [ require false ]
     * @support  array $staffIds 伙伴id列表 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAvailableStaffIds () {
        return self::getClass()->getAvailableStaffIds([
        ]);
    }

    /**
     * 获取当前挂起的用户列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCurrentHangStaffs () {
        return self::getClass()->getCurrentHangStaffs();
    }

    /**
     * 获取挂起超时的用户列表
     *
     * @support  int $time 挂起时间 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHangTimeoutStaffs () {
        return self::getClass()->getHangTimeoutStaffs([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Paperless\StoreStaff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Paperless\StoreStaff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}