<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method tabOrderUpdateNotDealWithByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\UploadRecord\NeedlessUploadStatusCmd $params)
 * @method variousUploadedTotalByParams(array $params)
 */
class UploadRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 标记订单无需处理
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\UploadRecord\NeedlessUploadStatusCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function tabOrderUpdateNotDealWith (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\UploadRecord\NeedlessUploadStatusCmd $cmd) {
        return self::getClass()->tabOrderUpdateNotDealWith($cmd);
    }


    /**
     * 获取各上传总数
     *
     * @support  string $type 查询类型 [ require false ]
     * @support  string $searchTimeField 搜索字段 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  bool $todayTakeOrder 是否查询今日新接单 [ require false ]
     * @support  int $orderId 订单id [ require false ]
     * @support  bool $updatable 查询有更新的订单 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function variousUploadedTotal () {
        return self::getClass()->variousUploadedTotal([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\UploadRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\UploadRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}