<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Ding;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderUserInfoByParams(array $params)
 * @method getOrderUserCouponsByParams(array $params)
 */
class OrderUserDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户信息
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetOrderUserInfoDTO
     */
    public static function getOrderUserInfo (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderUserInfo([
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\FamilyPaperless\Ding\DTO\GetOrderUserInfoDTO"
        );
    }

    /**
     * 获取用户信息
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderUserCoupons (int $orderId) {
        return self::getClass()->getOrderUserCoupons([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Ding\OrderUserDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Ding\OrderUserDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}