<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSelfStoreStreamQueueByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\StreamQueue\QueueListCmd $params)
 */
class CloudStreamQueue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取本门店云端队列信息
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\StreamQueue\QueueListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\StreamQueue\QueueListDTO
     */
    public static function getSelfStoreStreamQueue (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\StreamQueue\QueueListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSelfStoreStreamQueue($cmd),
            "\Mainto\Bridge\Structs\FamilyPaperless\Manage\DTO\StreamQueue\QueueListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\CloudStreamQueue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\CloudStreamQueue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}