<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage\Paperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getQueueInfoByParams(array $params)
 * @method debugByParams(array $params)
 */
class Debug {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getQueueInfo
     *
     * @param  string $storeId storeId [ require true ]
     * @param  bool $refresh refresh [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getQueueInfo (string $storeId, bool $refresh = false) {
        return self::getClass()->getQueueInfo([
            "storeId" => $storeId,
            "refresh" => $refresh,
        ]);
    }

    /**
     * debug
     *
     * @support  string $orderNo orderNo [ require false ]
     * @support  string $orderId orderId [ require false ]
     * @support  string $staffId orderId [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function debug () {
        return self::getClass()->debug([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Paperless\Debug');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Paperless\Debug');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}