<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage\Paperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveNoteByParams(array $params)
 * @method getOrderStageNumsByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\GetOrderStageNumsCmd $params)
 * @method assignStageStaffByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\AssignStageStaffCmd $params)
 * @method cancelAssignStageStaffByParams(array $params)
 * @method hangByParams(array $params)
 * @method cancelHangByParams(array $params)
 * @method changeStaffByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\ChangeStaffCmd $params)
 * @method updateSortByParams(array $params)
 * @method getOrderAvailableStaffsByParams(array $params)
 * @method getOrderPreAssignStaffsByParams(array $params)
 * @method getOrderCurrentAssignStaffsByParams(array $params)
 * @method getCanTakeOrderStaffIdsByParams(array $params)
 * @method backWaitPhotographyByParams(array $params)
 * @method backWaitMakeUpByParams(array $params)
 * @method backWaitLookPhotoByParams(array $params)
 * @method hasOffProductsByParams(array $params)
 * @method getStageStaffsByParams(array $params)
 * @method recoverByParams(array $params)
 * @method bigOrderByParams(array $params)
 * @method checkNeedPaperlessByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新订单备注信息
     *
     * @support  int $orderId 订单id [ require false ]
     * @support  string $note 备注 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveNote () {
        return self::getClass()->saveNote([
        ]);
    }

    /**
     * 门店流程数量统计
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\GetOrderStageNumsCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderStageNums (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\GetOrderStageNumsCmd $cmd) {
        return self::getClass()->getOrderStageNums($cmd);
    }


    /**
     * 指定订单接单伙伴
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\AssignStageStaffCmd $assignStageStaffCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function assignStageStaff (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\AssignStageStaffCmd $assignStageStaffCmd) {
        return self::getClass()->assignStageStaff($assignStageStaffCmd);
    }


    /**
     * 清除订单接单伙伴
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $stage 阶段 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelAssignStageStaff () {
        return self::getClass()->cancelAssignStageStaff([
        ]);
    }

    /**
     * 挂起订单
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hang () {
        return self::getClass()->hang([
        ]);
    }

    /**
     * 取消挂起订单
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelHang () {
        return self::getClass()->cancelHang([
        ]);
    }

    /**
     * 更换伙伴
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\ChangeStaffCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function changeStaff (\Mainto\Bridge\Structs\FamilyPaperless\Manage\Cmd\Paperless\ChangeStaffCmd $cmd) {
        return self::getClass()->changeStaff($cmd);
    }


    /**
     * 更新接单顺序
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $sort 排序值 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateSort () {
        return self::getClass()->updateSort([
        ]);
    }

    /**
     * 获取订单可选的伙伴列表
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderAvailableStaffs () {
        return self::getClass()->getOrderAvailableStaffs([
        ]);
    }

    /**
     * 获取订单预指派的伙伴信息
     *
     * @support  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderPreAssignStaffs () {
        return self::getClass()->getOrderPreAssignStaffs([
        ]);
    }

    /**
     * 获取订单当前指派的伙伴信息
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderCurrentAssignStaffs (int $orderId) {
        return self::getClass()->getOrderCurrentAssignStaffs([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取订单可接单伙伴列表
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCanTakeOrderStaffIds () {
        return self::getClass()->getCanTakeOrderStaffIds([
        ]);
    }

    /**
     * 退回至等待摄影
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function backWaitPhotography () {
        return self::getClass()->backWaitPhotography([
        ]);
    }

    /**
     * 退回至等待化妆
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function backWaitMakeUp () {
        return self::getClass()->backWaitMakeUp([
        ]);
    }

    /**
     * 退回至看片排队中
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function backWaitLookPhoto () {
        return self::getClass()->backWaitLookPhoto([
        ]);
    }

    /**
     * 订单中是否存在已下架产品
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hasOffProducts () {
        return self::getClass()->hasOffProducts([
        ]);
    }

    /**
     * 获取订单的伙伴列表
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStageStaffs () {
        return self::getClass()->getStageStaffs([
        ]);
    }

    /**
     * 恢复到等待拍摄状态
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $token token [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function recover () {
        return self::getClass()->recover([
        ]);
    }

    /**
     * 是否是大订单
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bigOrder () {
        return self::getClass()->bigOrder([
        ]);
    }

    /**
     * 检查是否需要走钉钉无纸化（兼容family合并后部分老kids门店不走钉钉无纸化）
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkNeedPaperless (int $storeId) {
        return self::getClass()->checkNeedPaperless([
            "storeId" => $storeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\Paperless\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\Paperless\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}