<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Ding;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method continueToMakeUpByParams(array $params)
 * @method completeMakeUpByParams(array $params)
 * @method setAssistMakeUpNumByParams(array|\Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\AssistMakeUpNumCmd $params)
 * @method completePhotographyByParams(array $params)
 * @method completeAndHangByParams(array $params)
 * @method goSelectPhotoByParams(array $params)
 * @method orderAgainByParams(array $params)
 * @method takeOrderByParams(array $params)
 * @method saveNoteByParams(array $params)
 * @method getCloudProductInfoByParams(array $params)
 */
class ProcessDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 主化妆师继续化妆
     *
     * @support  int $processId 流程ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function continueToMakeUp ($context) {
        return self::getClass()->continueToMakeUp([
            "context" => $context,
        ]);
    }

    /**
     * 完成化妆
     *
     * @support  int $processId 流程ID [ require true ]
     * @support  array $item 交换产品信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function completeMakeUp ($context) {
        return self::getClass()->completeMakeUp([
            "context" => $context,
        ]);
    }

    /**
     * 修改妆面数量
     *
     * @var  \Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\AssistMakeUpNumCmd $assistMakeUpNumCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function setAssistMakeUpNum (\Mainto\Bridge\Structs\FamilyPaperless\Ding\Cmd\AssistMakeUpNumCmd $assistMakeUpNumCmd) {
        return self::getClass()->setAssistMakeUpNum($assistMakeUpNumCmd);
    }


    /**
     * 完成摄影
     *
     * @support  int $processId 流程ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function completePhotography ($context) {
        return self::getClass()->completePhotography([
            "context" => $context,
        ]);
    }

    /**
     * 完成并挂起
     *
     * @support  int $processId 流程ID [ require false ]
     * @support  array $item 交换产品信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function completeAndHang ($context) {
        return self::getClass()->completeAndHang([
            "context" => $context,
        ]);
    }

    /**
     * 完成摄影去选片
     *
     * @support  int $processId 流程ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function goSelectPhoto ($context) {
        return self::getClass()->goSelectPhoto([
            "context" => $context,
        ]);
    }

    /**
     * 再来一单
     *
     * @support  int $orderId 订单ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderAgain ($context) {
        return self::getClass()->orderAgain([
            "context" => $context,
        ]);
    }

    /**
     * 接新订单
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function takeOrder ($context) {
        return self::getClass()->takeOrder();
    }

    /**
     * 更新流程备注信息
     *
     * @support  int $processId 流程ID [ require false ]
     * @support  string $note 备注 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveNote ($context) {
        return self::getClass()->saveNote([
            "context" => $context,
        ]);
    }

    /**
     * 获取云端产品信息
     *
     * @support  int $processId 流程ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCloudProductInfo ($context) {
        return self::getClass()->getCloudProductInfo([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Ding\ProcessDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Ding\ProcessDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}