<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Paperless;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userSignInByParams(array|Process\UserSignIn\UserSignInCmd $params)
 * @method retouchSignInByParams(array|Process\RetouchSignIn\RetouchSignInCmd $params)
 * @method reviewStoreListByParams(array $params)
 */
class Process {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 前台签到
     *
     * @var  Process\UserSignIn\UserSignInCmd $userSignInCmd $userSignInCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function userSignIn (Process\UserSignIn\UserSignInCmd $userSignInCmd) {
        return self::getClass()->userSignIn($userSignInCmd);
    }


    /**
     * 看片签到
     *
     * @var  Process\RetouchSignIn\RetouchSignInCmd $retouchSignInCmd $retouchSignInCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function retouchSignIn (Process\RetouchSignIn\RetouchSignInCmd $retouchSignInCmd) {
        return self::getClass()->retouchSignIn($retouchSignInCmd);
    }


    /**
     * 支持预约看片门店列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reviewStoreList () {
        return self::getClass()->reviewStoreList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Paperless\Process');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Paperless\Process');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}