<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Ws;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRoomSignatureByParams(array $params)
 * @method enterRoomByParams(array $params)
 * @method checkWebsocketAliveByParams(array $params)
 */
class WebSocketDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取WS签名
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRoomSignature () {
        return self::getClass()->getRoomSignature();
    }

    /**
     * 加入WS房间
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function enterRoom () {
        return self::getClass()->enterRoom();
    }

    /**
     * 检查WS有效性
     *
     * @support  string $uuid UUID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkWebsocketAlive () {
        return self::getClass()->checkWebsocketAlive();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Ws\WebSocketDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Ws\WebSocketDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}