<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method assignSecondRetouchByParams(array $params)
 * @method changeSecondReviewingByParams(array $params)
 * @method getSecondRetouchChangeStoreOrderListByParams(array $params)
 * @method deleteByParams(array $params)
 * @method saveByParams(array $params)
 * @method findOneByOrderNumByParams(array $params)
 */
class ChangeStoreWatchPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 转门店看片指派
     *
     * @support  string $orderNum 订单号 require false
     * @support  int $staffId 工号 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function assignSecondRetouch () {
        return self::getClass()->assignSecondRetouch();
    }

    /**
     * 转门店看片操作直接进入审核中
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function changeSecondReviewing () {
        return self::getClass()->changeSecondReviewing();
    }

    /**
     * 获取转门店订单列表
     *
     * @support  string $orderNum 订单号 require false
     * @support  string $userName 姓名 require false
     * @support  string $userPhone 手机号 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 条数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getSecondRetouchChangeStoreOrderList () {
        return self::getClass()->getSecondRetouchChangeStoreOrderList();
    }

    /**
     * 删除看片转门店信息
     *
     * @support  string $orderNum 订单号 require false
     * @support  int $storeId 门店id require false
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 保存看片转门店信息
     *
     * @support  string $orderNum 订单号 require false
     * @support  int $storeId 门店id require false
     * @throws  \Exception
     * @return  bool
     */
    public static function save () {
        return self::getClass()->save();
    }

    /**
     * 获取看片转门店信息
     *
     * @support  string $orderNum 订单号 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function findOneByOrderNum () {
        return self::getClass()->findOneByOrderNum();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\ChangeStoreWatchPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\ChangeStoreWatchPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}