<?php
namespace Mainto\Bridge\Invokes\FamilyPaperless\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method reworkStreamByParams(array $params)
 * @method getOrderOnlineByParams(array $params)
 */
class SecondRetoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 看片退单
     *
     * @support  string $streamNum 流水号 [ require true ]
     * @support  array $photoData 照片信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function reworkStream () {
        return self::getClass()->reworkStream();
    }

    /**
     * 看片师已接订单
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOnline () {
        return self::getClass()->getOrderOnline();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('FamilyPaperless', 'Manage\SecondRetoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('FamilyPaperless', 'Manage\SecondRetoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}