<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-30 15:19:05
 */
namespace Mainto\Bridge\Invokes\Export;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Task
 */
class Task {
    private static string $serviceName = "Export";

    private static string $className = "Task";

    /**
     * 获取模板列表
     * @return  mixed
    */
    public static function getTemplateList (string $template_name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTemplateList(["template_name" => $template_name]);
    }
    /**
     * 获取列表 分页
     * @return  mixed
    */
    public static function getTaskListByPage (int $page = 1, int $page_size = 10, string $template_id, int $create_by) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTaskListByPage(["page" => $page, "page_size" => $page_size, "template_id" => $template_id, "create_by" => $create_by]);
    }
    /**
     * 获得模板支持的参数
     * @return  mixed
    */
    public static function getTemplateSupport (string $template_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTemplateSupport(["template_id" => $template_id]);
    }
    /**
     * getTaskInfo
     * @return  mixed
    */
    public static function getTaskInfo (string $task_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTaskInfo(["task_id" => $task_id]);
    }
    /**
     * 新增导出任务
     * @return  mixed
    */
    public static function newTaskFromApi (int $create_by, string $template_id, string $export_key, array $params) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTaskFromApi(["create_by" => $create_by, "template_id" => $template_id, "export_key" => $export_key, "params" => $params]);
    }
    /**
     * 新增导出任务
     * @return  mixed
    */
    public static function newTask (int $create_by, string $template_id, array $params) {
        return RpcClass::getClass(self::$serviceName, self::$className)->newTask(["create_by" => $create_by, "template_id" => $template_id, "params" => $params]);
    }
    /**
     * 监听
     * @return  mixed
    */
    public static function listen (string $task_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listen(["task_id" => $task_id]);
    }
    /**
     * 获取文件内容
     * @return  mixed
    */
    public static function getRaw (string $file_name, int $page = 1, int $page_size = 500, bool $is_keep_index = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRaw(["file_name" => $file_name, "page" => $page, "page_size" => $page_size, "is_keep_index" => $is_keep_index]);
    }
    /**
     * 下载文件
     * @return  mixed
    */
    public static function download (string $file_name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->download(["file_name" => $file_name]);
    }
    /**
     * 删除导出记录
     * @return  bool
    */
    public static function delete (int $create_by, array $task_ids, array $template_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["create_by" => $create_by, "task_ids" => $task_ids, "template_ids" => $template_ids]);
    }
    /**
     * 三方平台删除导出记录
     * @return  bool
    */
    public static function externalDelete (int $external_id, array $task_ids, array $template_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->externalDelete(["external_id" => $external_id, "task_ids" => $task_ids, "template_ids" => $template_ids]);
    }
    /**
     * 获取列表 分页
     * @return  array
    */
    public static function externalGetTaskListByPage (int $page = 1, int $page_size = 10, string $template_id, int $external_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->externalGetTaskListByPage(["page" => $page, "page_size" => $page_size, "template_id" => $template_id, "external_id" => $external_id]);
    }
    /**
     * 新增导出任务
     * @return  string
    */
    public static function externalNewTask (int $external_id, string $template_id, array $params) {
        return RpcClass::getClass(self::$serviceName, self::$className)->externalNewTask(["external_id" => $external_id, "template_id" => $template_id, "params" => $params]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}