<?php
namespace Mainto\Bridge\Invokes\Export;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTemplateListByParams(array $params)
 * @method getTaskListByPageByParams(array $params)
 * @method getTemplateSupportByParams(array $params)
 * @method getTaskInfoByParams(array $params)
 * @method newTaskFromApiByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method listenByParams(array $params)
 * @method getRawByParams(array $params)
 * @method downloadByParams(array $params)
 * @method deleteByParams(array $params)
 * @method externalDeleteByParams(array $params)
 * @method externalGetTaskListByPageByParams(array $params)
 * @method externalNewTaskByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取模板列表
     *
     * @support  string $template_name 模板名称 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTemplateList () {
        return self::getClass()->getTemplateList([
        ]);
    }

    /**
     * 获取列表 分页
     *
     * @support  string $template_id 导出模板id [ require false ]
     * @support  int $create_by 创建人 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTaskListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->getTaskListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获得模板支持的参数
     *
     * @param  string $template_id 模板id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTemplateSupport (string $template_id) {
        return self::getClass()->getTemplateSupport([
            "template_id" => $template_id,
        ]);
    }

    /**
     * getTaskInfo
     *
     * @param  string $task_id 任务id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTaskInfo (string $task_id) {
        return self::getClass()->getTaskInfo([
            "task_id" => $task_id,
        ]);
    }

    /**
     * ！！template_id 由对应执行类的类名生成 类名变则template_id变
     *
     * @param  string $template_id 模板id [ require true ]
     * @param  int $create_by 创建人 [ require true ]
     * @support  array $params 参数 [ require false ]
     * @param  string $export_key key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function newTaskFromApi (int $create_by, string $template_id, string $export_key) {
        return self::getClass()->newTaskFromApi([
            "create_by" => $create_by,
            "template_id" => $template_id,
            "export_key" => $export_key,
        ]);
    }

    /**
     * ！！template_id 由对应执行类的类名生成 类名变则template_id变
     *
     * @param  string $template_id 模板id [ require true ]
     * @param  int $create_by 创建人 [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function newTask (int $create_by, string $template_id) {
        return self::getClass()->newTask([
            "create_by" => $create_by,
            "template_id" => $template_id,
        ]);
    }

    /**
     * 监听
     *
     * @param  string $task_id 任务id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function listen (string $task_id) {
        return self::getClass()->listen([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 获取文件内容
     *
     * @param  string $file_name 文件名 [ require true ]
     * @param  bool $is_keep_index 是否保持索引 [ require false ]
     * @param  int $page_size 每次获取条数 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRaw (string $file_name, int $page = 1, int $page_size = 500, bool $is_keep_index = false) {
        return self::getClass()->getRaw([
            "file_name" => $file_name,
            "page" => $page,
            "page_size" => $page_size,
            "is_keep_index" => $is_keep_index,
        ]);
    }

    /**
     * 下载文件
     *
     * @param  string $file_name 文件名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function download (string $file_name) {
        return self::getClass()->download([
            "file_name" => $file_name,
        ]);
    }

    /**
     * 删除导出记录
     *
     * @support  array $task_ids 任务id [ require false ]
     * @support  array $template_ids 模板ids [ require false ]
     * @param  int $create_by 创建人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $create_by) {
        return self::getClass()->delete([
            "create_by" => $create_by,
        ]);
    }

    /**
     * 三方平台删除导出记录
     *
     * @support  array $task_ids 任务id [ require false ]
     * @support  array $template_ids 模板ids [ require false ]
     * @param  string $external_id 三方平台用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function externalDelete (string $external_id) {
        return self::getClass()->externalDelete([
            "external_id" => $external_id,
        ]);
    }

    /**
     * 获取列表 分页
     *
     * @support  string $template_id 导出模板id [ require false ]
     * @support  string $external_id 三方平台用户id [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function externalGetTaskListByPage (int $page = 1, int $page_size = 10) {
        return self::getClass()->externalGetTaskListByPage([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * ！！template_id 由对应执行类的类名生成 类名变则template_id变
     *
     * @param  string $template_id 模板id [ require true ]
     * @param  string $external_id 三方平台用户id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function externalNewTask (string $external_id, string $template_id) {
        return self::getClass()->externalNewTask([
            "external_id" => $external_id,
            "template_id" => $template_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Export', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Export', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}