<?php
namespace Mainto\Bridge\Invokes\Erp\Reservation\Mantusy;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllBannerByParams(array $params)
 * @method addBannerByParams(array $params)
 * @method editBannerByParams(array $params)
 * @method deleteBannerByParams(array $params)
 */
class MantusyBanner {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取缦图摄影所有Banner
     *
     * @support  string $state 状态（wait_release-下线 released-上线） 
     * @throws  \Exception
     * @return  array
     */
    public static function getAllBanner () {
        return self::getClass()->getAllBanner();
    }

    /**
     * 添加缦图摄影Banner
     *
     * @support  string $name banner名称 [ require true ]
     * @support  string $img_path 图片地址 [ require true ]
     * @support  int $sequence 排序 
     * @support  string $url 跳转地址 
     * @support  string $state 状态（wait_release-下线 released-上线） 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addBanner () {
        return self::getClass()->addBanner();
    }

    /**
     * 编辑缦图摄影Banner
     *
     * @support  string $name banner名称 [ require true ]
     * @param  string $_id _id [ require true ]
     * @support  string $img_path 图片地址 [ require true ]
     * @support  int $sequence 排序 
     * @support  string $url 跳转地址 
     * @support  string $state 状态（wait_release-下线 released-上线） 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editBanner (string $_id) {
        return self::getClass()->editBanner([
            "_id" => $_id,
        ]);
    }

    /**
     * 删除缦图摄影Banner
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteBanner (string $_id) {
        return self::getClass()->deleteBanner([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Erp', 'Reservation\Mantusy\MantusyBanner');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Erp', 'Reservation\Mantusy\MantusyBanner');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}