<?php
namespace Mainto\Bridge\Invokes\Erp\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPlacesByParams(array $params)
 * @method inboundByParams(array $params)
 * @method allocateByParams(array $params)
 * @method damagedByParams(array $params)
 * @method getAllFlowByParams(array $params)
 * @method getInventoryListByParams(array $params)
 */
class InventoryProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有库存地
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPlaces () {
        return self::getClass()->getPlaces();
    }

    /**
     * 手动入库
     *
     * @support  string $stock_place 库存地 [ require true ]
     * @support  int $product_id 商品id [ require true ]
     * @support  int $counts 入库数量 [ require true ]
     * @support  float $price 单价 [Original type double] [ require true ]
     * @support  string $supplier 供应商 
     * @support  string $apply_remark 申请备注 
     * @support  string $applicant 申请人 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function inbound () {
        return self::getClass()->inbound();
    }

    /**
     * 调拨
     *
     * @support  string $stock_place 库存地 [ require true ]
     * @support  int $product_id 产品id [ require true ]
     * @support  int $counts 调配数量 [ require true ]
     * @support  array $asset_numbers 调配编号 
     * @support  string $allocation_to 调配至 [ require true ]
     * @support  string $apply_remark 申请备注 
     * @support  string $applicant 申请人 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function allocate () {
        return self::getClass()->allocate();
    }

    /**
     * 报损
     *
     * @support  string $stock_place 库存地 [ require true ]
     * @support  int $product_id 记录id [ require true ]
     * @support  int $counts 报损数量 [ require true ]
     * @support  array $asset_numbers 报损编号 
     * @support  string $apply_remark 申请备注 
     * @support  string $applicant 申请人 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function damaged () {
        return self::getClass()->damaged();
    }

    /**
     * 获取库存流动信息
     *
     * @support  string $stock_place 库存地 
     * @support  string $product_name 产品名称 
     * @support  string $product_no 产品编号 
     * @support  int $parent_node 上级分类 
     * @support  string $created_at_start 操作时间起 
     * @support  string $created_at_end 操作时间止 
     * @support  string $type 操作类型 
     * @param  int $page_size 每页条数 [ require true ]
     * @param  int $page 第n页 [ require true ]
     * @param  bool $all 是否显示所有 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllFlow (bool $all = false, int $page_size = 10, int $page = 1) {
        return self::getClass()->getAllFlow([
            "all" => $all,
            "page_size" => $page_size,
            "page" => $page,
        ]);
    }

    /**
     * 获取库存信息
     *
     * @support  string $stock_place 库存地 
     * @support  string $product_name 产品名称 
     * @support  string $product_no 产品编号 
     * @support  int $parent_node 上级分类 
     * @param  int $page_size 每页条数 [ require true ]
     * @param  int $page 第n页 [ require true ]
     * @support  bool $all 是否显示所有 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInventoryList (int $page = 1, int $page_size = 10) {
        return self::getClass()->getInventoryList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Erp', 'InventoryProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Erp', 'InventoryProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}