<?php
namespace Mainto\Bridge\Invokes\Erp\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductTreeNodeByParams(array $params)
 * @method getProductTreeByParams(array $params)
 * @method editProductTreeNodeByParams(array $params)
 * @method deleteProductTreeNodeByParams(array $params)
 * @method testByParams(array $params)
 */
class InventoryCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加一个后台类目节点
     *
     * @support  int $parentNodeId 父节点 [Original type uint] 
     * @support  string $name 节点名称 [ require true ]
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProductTreeNode () {
        return self::getClass()->addProductTreeNode();
    }

    /**
     * 获取后台类目树结构
     * @deprecated
     *
     * @param  int $parentNodeId 父节点ID [Original type uint] [ require true ]
     * @param  bool $treeMode 是否需要整理返回为树状结构 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductTree (int $parentNodeId = NULL, bool $treeMode = true) {
        return self::getClass()->getProductTree([
            "parentNodeId" => $parentNodeId,
            "treeMode" => $treeMode,
        ]);
    }

    /**
     * 修改一个后台类目节点
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @param  int $parentNodeId 父节点ID [Original type uint] [ require true ]
     * @support  string $name 节点名称 
     * @support  array $extend 拓展信息 
     * @support  array $merge_extend 需要合并的拓展信息 
     * @throws  \Exception
     * @return  array
     */
    public static function editProductTreeNode (int $nodeId, int $parentNodeId) {
        return self::getClass()->editProductTreeNode([
            "nodeId" => $nodeId,
            "parentNodeId" => $parentNodeId,
        ]);
    }

    /**
     * 删除一个后台类目节点
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @param  bool $deleteChild 同步删除子节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteProductTreeNode (int $nodeId, bool $deleteChild = false) {
        return self::getClass()->deleteProductTreeNode([
            "nodeId" => $nodeId,
            "deleteChild" => $deleteChild,
        ]);
    }

    /**
     * 测试调试
     *
     * @throws  \Exception
     * @return  string
     */
    public static function test () {
        return self::getClass()->test();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Erp', 'InventoryCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Erp', 'InventoryCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}