<?php
namespace Mainto\Bridge\Invokes\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getManagerListByParams(array $params)
 * @method getStaffIdsByRealOrNickNameByParams(array $params)
 * @method getStaffPermissionListByParams(array $params)
 * @method getStaffRoleListByParams(array $params)
 * @method getPermissionListByParams(array $params)
 * @method getRoleListByParams(array $params)
 * @method getOneRoleByParams(array $params)
 * @method grantRoleByParams(array $params)
 * @method grantPermissionsByParams(array $params)
 * @method enableAccountByParams(array $params)
 * @method disableAccountByParams(array $params)
 * @method createRoleByParams(array $params)
 * @method editRoleByParams(array $params)
 * @method deleteRoleByParams(array $params)
 * @method createPermissionByParams(array $params)
 * @method getStaffInfoByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 * @method judgeAccountByParams(array $params)
 * @method judgeAccountExistByParams(array $params)
 */
class Auth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取管理员列表
     *
     * @support  string $staffName 姓名或花名 
     * @param  int $page 页数 [ require true ]
     * @param  int $page_size 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getManagerList (int $page = 1, int $page_size = 15) {
        return self::getClass()->getManagerList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 通过伙伴姓名或花名获得可能的工号
     *
     * @param  string $staffName 伙伴姓名或花名 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffIdsByRealOrNickName (string $staffName) {
        return self::getClass()->getStaffIdsByRealOrNickName([
            "staffName" => $staffName,
        ]);
    }

    /**
     * 通过伙伴id获取对应权限
     *
     * @param  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffPermissionList (int $staffId) {
        return self::getClass()->getStaffPermissionList([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 通过伙伴id获取权限组
     *
     * @param  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffRoleList (int $staffId) {
        return self::getClass()->getStaffRoleList([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取所有权限列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissionList () {
        return self::getClass()->getPermissionList();
    }

    /**
     * 获取所有权限组列表
     *
     * @param  string $title 权限组名称 [ require true ]
     * @param  bool $all 是否显示全部 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRoleList (string $title = '', bool $all = true, int $page = 1, int $page_size = 15) {
        return self::getClass()->getRoleList([
            "title" => $title,
            "all" => $all,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取某个权限组下的所有权限
     *
     * @param  int $roleId 权限组id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOneRole (int $roleId) {
        return self::getClass()->getOneRole([
            "roleId" => $roleId,
        ]);
    }

    /**
     * 伙伴权限组授权
     *
     * @param  int $roleId 角色ID [ require true ]
     * @param  int $staffId 伙伴ID [ require true ]
     * @param  bool $isModify 是否修改授权 [ require true ]
     * @param  int $effectAt 起效时间(0-立即生效) [ require true ]
     * @param  int $expireAt 过期时间(0-永不过期) [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function grantRole (int $roleId, int $staffId, bool $isModify = false, int $effectAt = 0, int $expireAt = 0) {
        return self::getClass()->grantRole([
            "roleId" => $roleId,
            "staffId" => $staffId,
            "isModify" => $isModify,
            "effectAt" => $effectAt,
            "expireAt" => $expireAt,
        ]);
    }

    /**
     * 伙伴权限批量授权
     *
     * @param  array $permission_ids 权限数组 [ require true ]
     * @param  int $staff_id 伙伴id [ require true ]
     * @param  int $effectAt 起效时间(0-立即生效) [ require true ]
     * @param  int $expireAt 过期时间(0-永不过期) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function grantPermissions (int $staff_id, array $permission_ids = [], int $effectAt = 0, int $expireAt = 0) {
        return self::getClass()->grantPermissions([
            "staff_id" => $staff_id,
            "permission_ids" => $permission_ids,
            "effectAt" => $effectAt,
            "expireAt" => $expireAt,
        ]);
    }

    /**
     * 启用账号
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableAccount (int $staffId) {
        return self::getClass()->enableAccount([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 停用账号
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableAccount (int $staffId) {
        return self::getClass()->disableAccount([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 创建权限组
     *
     * @param  string $title 权限组名称 [ require true ]
     * @param  array $permission_ids 权限数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createRole (string $title, array $permission_ids) {
        return self::getClass()->createRole([
            "title" => $title,
            "permission_ids" => $permission_ids,
        ]);
    }

    /**
     * 修改权限组
     *
     * @param  int $roleId 权限组id [ require true ]
     * @param  array $permission_ids 权限数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRole (int $roleId, array $permission_ids) {
        return self::getClass()->editRole([
            "roleId" => $roleId,
            "permission_ids" => $permission_ids,
        ]);
    }

    /**
     * 删除权限组
     *
     * @param  int $roleId 权限组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteRole (int $roleId) {
        return self::getClass()->deleteRole([
            "roleId" => $roleId,
        ]);
    }

    /**
     * 创建权限
     *
     * @param  string $name 权限标示 [ require true ]
     * @param  string $title 权限名 [ require true ]
     * @param  string $desc 权限描述 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPermission (string $name, string $title, string $desc = '') {
        return self::getClass()->createPermission([
            "name" => $name,
            "title" => $title,
            "desc" => $desc,
        ]);
    }

    /**
     * 根据工号获取伙伴信息
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffInfo (int $staffId) {
        return self::getClass()->getStaffInfo([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取管理员信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * 判断账号可用情况
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function judgeAccount (int $staffId) {
        return self::getClass()->judgeAccount([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 判断账号是否在应用中
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function judgeAccountExist (int $staffId) {
        return self::getClass()->judgeAccountExist([
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Erp', 'Auth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Erp', 'Auth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}