<?php
namespace Mainto\Bridge\Invokes\Erp\Reservation\Mantusy;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTreeByParams(array $params)
 * @method addCategoryNodeByParams(array $params)
 * @method editCategoryNodeByParams(array $params)
 * @method deleteCategoryNodeByParams(array $params)
 */
class MantusyCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取缦图摄影产品树
     *
     * @param  int $parentNodeId 父节点ID [Original type uint] [ require true ]
     * @param  array $nodeType 要筛选的节点类型 [ require true ]
     * @param  bool $treeMode 是否需要整理返回为树状结构 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTree (int $parentNodeId = NULL, array $nodeType = [0 => 'node'], bool $treeMode = true) {
        return self::getClass()->getTree([
            "parentNodeId" => $parentNodeId,
            "nodeType" => $nodeType,
            "treeMode" => $treeMode,
        ]);
    }

    /**
     * 添加缦图摄影类目节点
     *
     * @param  int $parentNodeId 父节点 [Original type uint] [ require true ]
     * @param  string $name 节点名称 [ require true ]
     * @param  bool $is_hidden 下架状态 [ require true ]
     * @param  int $sort 排序顺序 [Original type uint] [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addCategoryNode (int $parentNodeId, string $name, bool $is_hidden = true, int $sort = 0, array $extend = []) {
        return self::getClass()->addCategoryNode([
            "parentNodeId" => $parentNodeId,
            "name" => $name,
            "is_hidden" => $is_hidden,
            "sort" => $sort,
            "extend" => $extend,
        ]);
    }

    /**
     * 修改缦图摄影类目节点
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @support  string $name 节点名称 
     * @support  bool $is_hidden 下架状态 
     * @support  int $sort 排序顺序 [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  array
     */
    public static function editCategoryNode (int $nodeId) {
        return self::getClass()->editCategoryNode([
            "nodeId" => $nodeId,
        ]);
    }

    /**
     * 删除缦图摄影类目节点
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteCategoryNode (int $nodeId) {
        return self::getClass()->deleteCategoryNode([
            "nodeId" => $nodeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Erp', 'Reservation\Mantusy\MantusyCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Erp', 'Reservation\Mantusy\MantusyCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}