<?php
namespace Mainto\Bridge\Invokes\Erp\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createActiveByParams(array $params)
 * @method searchActiveByParams(array $params)
 * @method searchByIdByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method startApprovalByParams(array $params)
 * @method upDownActivePageByParams(array $params)
 * @method approvalHookByParams(array $params)
 * @method receiveCouponByParams(array $params)
 * @method getJssdkByParams(array $params)
 */
class ActivePage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建一个活动
     *
     * @support  string $category 分类 [ require true ]
     * @support  string $name 活动名称 [ require true ]
     * @support  string $create_by 创建者 [ require true ]
     * @support  string $template 模板key [ require true ]
     * @support  array $extend 扩展信息 [ require true ]
     * @support  string $link 活动页面链接 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createActive () {
        return self::getClass()->createActive();
    }

    /**
     * 活动查询
     *
     * @support  string $category 分类 
     * @support  string $name 活动名称 
     * @support  string $template 模板key 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @support  bool $all 是否返回所有结果 
     * @throws  \Exception
     * @return  array
     */
    public static function searchActive () {
        return self::getClass()->searchActive();
    }

    /**
     * 单个活动查询
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchById (string $_id) {
        return self::getClass()->searchById([
            "_id" => $_id,
        ]);
    }

    /**
     * 更新活动
     *
     * @support  string $_id id [ require true ]
     * @support  string $category 分类 
     * @support  string $name 活动名称 
     * @support  string $template 模板key 
     * @support  int $auditor 审核者 
     * @support  array $extend 扩展信息 
     * @support  string $link 活动页面链接 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除活动
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 活动申请上线（进入钉钉审批流程）
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startApproval (string $_id) {
        return self::getClass()->startApproval([
            "_id" => $_id,
        ]);
    }

    /**
     * 上线或下线活动
     *
     * @param  string $_id id [ require true ]
     * @param  string $page_state 页面上线状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upDownActivePage (string $_id, string $page_state) {
        return self::getClass()->upDownActivePage([
            "_id" => $_id,
            "page_state" => $page_state,
        ]);
    }

    /**
     * 审批事件回调监听
     *
     * @param  string $type 回调类型 [ require true ]
     * @param  string $EventType 事件类型 [ require true ]
     * @support  string $processInstanceId 审批实例id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function approvalHook (string $type, string $EventType) {
        return self::getClass()->approvalHook([
            "type" => $type,
            "EventType" => $EventType,
        ]);
    }

    /**
     * 用户领券
     *
     * @param  string $_id 活动id [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @param  string $channel 渠道号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function receiveCoupon (string $_id, string $phone, string $code = '', string $channel = '') {
        return self::getClass()->receiveCoupon([
            "_id" => $_id,
            "phone" => $phone,
            "code" => $code,
            "channel" => $channel,
        ]);
    }

    /**
     * 获取微信签名jssdk配置
     *
     * @param  string $_id 活动id [ require true ]
     * @param  string $url 活动链接 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getJssdk (string $_id, string $url) {
        return self::getClass()->getJssdk([
            "_id" => $_id,
            "url" => $url,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Erp', 'ActivePage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Erp', 'ActivePage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}