<?php
namespace Mainto\Bridge\Invokes\Erp\Inventory;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductByParams(array $params)
 * @method editProductByParams(array $params)
 * @method deleteProductTreeNodeByParams(array $params)
 */
class InventoryFlow {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加一个商品
     *
     * @support  int $parentNodeId 父节点ID [Original type uint] [ require true ]
     * @support  string $name 商品名称 [ require true ]
     * @support  string $product_no 商品编号 [ require true ]
     * @support  string $unit 计量单位 [ require true ]
     * @support  string $brand 品牌 
     * @support  array $attributeValue 属性对应值 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProduct () {
        return self::getClass()->addProduct();
    }

    /**
     * 编辑商品
     *
     * @param  int $productNodeId 商品节点ID [Original type uint] [ require true ]
     * @param  int $parentNodeId 父节点ID [Original type uint] [ require true ]
     * @support  string $name 商品名称 
     * @support  string $product_no 商品编号 [ require true ]
     * @support  string $unit 计量单位 [ require true ]
     * @support  string $brand 品牌 
     * @support  array $attributeValue 属性对应值 
     * @throws  \Exception
     * @return  array
     */
    public static function editProduct (int $productNodeId, int $parentNodeId) {
        return self::getClass()->editProduct([
            "productNodeId" => $productNodeId,
            "parentNodeId" => $parentNodeId,
        ]);
    }

    /**
     * 删除一个商品
     *
     * @param  int $productNodeId 商品节点ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteProductTreeNode (int $productNodeId) {
        return self::getClass()->deleteProductTreeNode([
            "productNodeId" => $productNodeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Erp', 'InventoryFlow');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Erp', 'InventoryFlow');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}