<?php
namespace Mainto\Bridge\Invokes\Erp\Reservation\Mantusy;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductNodeByParams(array $params)
 * @method getProductInfoByNodeIdByParams(array $params)
 * @method editProductNodeByParams(array $params)
 * @method downProductByParams(array $params)
 * @method upProductByParams(array $params)
 * @method deleteProductByParams(array $params)
 */
class MantusyProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加缦图摄影产品节点
     *
     * @param  int $parentNodeId 父节点 [Original type uint] [ require true ]
     * @param  string $name 节点名称 [ require true ]
     * @param  string $nodeType 节点类型 [ require true ]
     * @param  bool $is_hidden 下架状态 [ require true ]
     * @param  int $sort 排序顺序 [Original type uint] [ require true ]
     * @param  array $price 价格 [ require true ]
     * @param  array $extend 拓展信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addProductNode (int $parentNodeId, string $name, string $nodeType = 'product', bool $is_hidden = true, int $sort = 0, array $price = [], array $extend = []) {
        return self::getClass()->addProductNode([
            "parentNodeId" => $parentNodeId,
            "name" => $name,
            "nodeType" => $nodeType,
            "is_hidden" => $is_hidden,
            "sort" => $sort,
            "price" => $price,
            "extend" => $extend,
        ]);
    }

    /**
     * 根据产品节点ID获取产品详细信息
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductInfoByNodeId (int $id) {
        return self::getClass()->getProductInfoByNodeId([
            "id" => $id,
        ]);
    }

    /**
     * 修改缦图摄影产品节点
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @support  string $name 节点名称 
     * @support  bool $is_hidden 下架状态 
     * @support  int $sort 排序顺序 [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  array
     */
    public static function editProductNode (int $nodeId) {
        return self::getClass()->editProductNode([
            "nodeId" => $nodeId,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  array $nodeIds 要下架的产品ID [Original type array&lt;int&gt;] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function downProduct (array $nodeIds) {
        return self::getClass()->downProduct([
            "nodeIds" => $nodeIds,
        ]);
    }

    /**
     * 上架产品
     *
     * @param  array $nodeIds 要上架的产品ID [Original type array&lt;int&gt;] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function upProduct (array $nodeIds) {
        return self::getClass()->upProduct([
            "nodeIds" => $nodeIds,
        ]);
    }

    /**
     * 删除缦图摄影产品节点
     *
     * @param  int $nodeId 节点ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteProduct (int $nodeId) {
        return self::getClass()->deleteProduct([
            "nodeId" => $nodeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Erp', 'Reservation\Mantusy\MantusyProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Erp', 'Reservation\Mantusy\MantusyProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}