<?php
namespace Mainto\Bridge\Invokes\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method upyunConfigByParams(array $params)
 * @method getHostPrefixByParams(array $params)
 * @method upyunSignatureByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getUpyunSignatureByParams(array $params)
 * @method getTreeByParams(array $params)
 * @method productSortAdjustByParams(array $params)
 * @method bannerSortAdjustByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 又拍云配置
     *
     * @param  string $upyun_key upyun_key [ require true ]
     * @param  string $prefix 路径 [ require true ]
     * @param  string $save_key 保存key [ require true ]
     * @param  string $bucket 空间名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upyunConfig (string $upyun_key, string $prefix, string $save_key, string $bucket) {
        return self::getClass()->upyunConfig([
            "upyun_key" => $upyun_key,
            "prefix" => $prefix,
            "save_key" => $save_key,
            "bucket" => $bucket,
        ]);
    }

    /**
     * 得到host地址
     * @deprecated
     *
     * @param  string $upyun_key 又拍云key [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getHostPrefix (string $upyun_key) {
        return self::getClass()->getHostPrefix([
            "upyun_key" => $upyun_key,
        ]);
    }

    /**
     * 获取又拍云签名
     * @deprecated
     *
     * @param  string $upyun_key 又拍云key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upyunSignature (string $upyun_key) {
        return self::getClass()->upyunSignature([
            "upyun_key" => $upyun_key,
        ]);
    }

    /**
     * 得到host地址(通过模块）
     *
     * @param  string $module 模块名 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getHost (string $module) {
        return self::getClass()->getHost([
            "module" => $module,
        ]);
    }

    /**
     * 获取又拍云签名(通过模块）
     *
     * @param  string $module 模块名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSignature (string $module) {
        return self::getClass()->getUpyunSignature([
            "module" => $module,
        ]);
    }

    /**
     * 获取产品树
     *
     * @param  int $parentNodeId 父节点ID [Original type uint] [ require true ]
     * @param  array $nodeType 要筛选的节点类型 [ require true ]
     * @param  bool $treeMode 是否需要整理返回为树状结构 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTree (int $parentNodeId = NULL, array $nodeType = [0 => 'node'], bool $treeMode = true) {
        return self::getClass()->getTree([
            "parentNodeId" => $parentNodeId,
            "nodeType" => $nodeType,
            "treeMode" => $treeMode,
        ]);
    }

    /**
     * 产品与分类排序调整
     *
     * @param  array $productSorts 待排序数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSortAdjust (array $productSorts) {
        return self::getClass()->productSortAdjust([
            "productSorts" => $productSorts,
        ]);
    }

    /**
     * banner图排序调整
     *
     * @param  array $bannerSorts 待排序数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bannerSortAdjust (array $bannerSorts) {
        return self::getClass()->bannerSortAdjust([
            "bannerSorts" => $bannerSorts,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Erp', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Erp', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}