<?php
namespace Mainto\Bridge\Invokes\DataCenter\PartnerHome;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTypesByParams(array $params)
 * @method createByParams(array $params)
 * @method createAllByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method incrementByParams(array $params)
 */
class PartnerHomeNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取类型列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTypes () {
        return self::getClass()->getTypes();
    }

    /**
     * 创建记录
     *
     * @support  string $state 状态位 [ require true ]
     * @support  array $type 类型 [ require true ]
     * @support  array $images 图片 [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $content 公告内容 [ require true ]
     * @support  int $staff_num 用户工号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 创建记录批量
     *
     * @support  string $state 状态位 [ require true ]
     * @param  array $type 类型 [ require true ]
     * @support  array $images 图片 [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $content 公告内容 [ require true ]
     * @support  int $staff_num 用户工号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAll (array $type) {
        return self::getClass()->createAll([
            "type" => $type,
        ]);
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  string $state 状态位 [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  string $images 图片 [ require false ]
     * @support  string $title 标题 [ require false ]
     * @support  string $content 公告内容 [ require false ]
     * @support  int $staff_num 用户工号 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页数量 [ require false ]
     * @param  bool $all 是否返回所有结果 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByPage (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->getListByPage([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  string $_id id [ require true ]
     * @support  string $state 状态位 [ require false ]
     * @support  array $type 类型 [ require false ]
     * @support  array $images 图片 [ require false ]
     * @support  string $title 标题 [ require false ]
     * @support  string $content 公告内容 [ require false ]
     * @support  int $staff_num 用户工号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 自增 已解决量|未解决量
     *
     * @param  string $_id id [ require true ]
     * @param  int $staff_num staff_num [ require true ]
     * @param  string $column 自增字段(read_count) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function increment (string $_id, int $staff_num, string $column = 'read_count') {
        return self::getClass()->increment([
            "_id" => $_id,
            "staff_num" => $staff_num,
            "column" => $column,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'PartnerHome\PartnerHomeNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'PartnerHome\PartnerHomeNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}