<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method searchByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByParams(array $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增
     *
     * @support  string $order_num 订单编号 [ require false ]
     * @support  string $refund_type 退款类型 [ require true ]
     * @support  float $refund_money 退款金额 [ require true ]
     * @support  string $refund_people 退款人 [ require true ]
     * @support  string $refund_account 退款账户 [ require true ]
     * @support  int $refund_scale 退款比例 [ require true ]
     * @support  int $refund_reason 退款原因 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 [ require false ]
     * @support  bool $is_refund_card 是否退券 [ require false ]
     * @support  string $refund_note 退款备注 [ require false ]
     * @support  int $refund_goods_id 其他退款类型需要的商品ID [ require false ]
     * @support  string $refund_content 退款内容 (只有退款至礼品卡会使用此字段 : all : 全部 order: 初始支付 ds_all: 全部二销，{$ds_sku_id} : ds 产品id) [ require false ]
     * @support  string $refund_part 退款部分 [ require false ]
     * @support  int $store_id 退款门店 [ require false ]
     * @support  string $state 退款状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 更新
     *
     * @param  string $_id 退款id [ require true ]
     * @param  string $state 退款状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id, string $state) {
        return self::getClass()->update([
            "_id" => $_id,
            "state" => $state,
        ]);
    }

    /**
     * 查询
     *
     * @param  int $search_type 查询时间类型【1:按照提交时间 2:按照退款时间】 [ require true ]
     * @support  string $start_at 开始时间 [ require false ]
     * @support  string $end_at 结束时间 [ require false ]
     * @support  int $store_id 门店id [ require false ]
     * @support  string $order_num 订单号 [ require false ]
     * @support  int $refund_reason 退款原因类型 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页显示数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function search (int $search_type, int $page = 1, int $page_size = 10) {
        return self::getClass()->search([
            "search_type" => $search_type,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  string $_id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 获取列表不分页
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList (string $order_num) {
        return self::getClass()->getList([
            "order_num" => $order_num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}