<?php
namespace Mainto\Bridge\Invokes\DataCenter\PartnerHome;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTypesByParams(array $params)
 * @method createByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method updateByParams(array $params)
 * @method handleStaffGroupUpdateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method incrementReadCountByParams(array $params)
 * @method incrementClickCountByParams(array $params)
 * @method decrementClickCountByParams(array $params)
 * @method isClickedByParams(array $params)
 */
class PartnerHomeBroadcast {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getTypes
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTypes () {
        return self::getClass()->getTypes();
    }

    /**
     * 创建记录
     *
     * @support  string $type 类型 [ require true ]
     * @support  string $image 图片 [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  string $state 状态 [ require false ]
     * @support  int $read_time 需阅读时间 [ require false ]
     * @support  int $wish_value 愿望值 [ require false ]
     * @support  string $content 内容 [ require true ]
     * @support  int $create_by 创建人 [ require true ]
     * @support  array $to_group 分组id [ require true ]
     * @support  array $appendix 附件 [ require false ]
     * @support  array $extend 拓展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  string $title 标题 [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  array $to_group 分组ids [ require false ]
     * @support  string $state 状态 [ require false ]
     * @support  string $created_at_start 添加日期起 [ require false ]
     * @support  string $created_at_end 添加日期止 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页数量 [ require false ]
     * @param  bool $all 是否返回所有结果 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByPage (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->getListByPage([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  string $_id id [ require true ]
     * @support  string $type 类型 [ require false ]
     * @support  string $image 图片 [ require false ]
     * @support  string $title 标题 [ require false ]
     * @support  int $read_time 需阅读时间 [ require false ]
     * @support  int $wish_value 愿望值 [ require false ]
     * @support  string $content 内容 [ require false ]
     * @support  int $create_by 创建人 [ require false ]
     * @support  array $to_group 分组id [ require false ]
     * @support  string $state 状态位 [ require false ]
     * @support  array $appendix 附件 [ require false ]
     * @support  array $extend 拓展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * handleStaffGroupUpdate
     *
     * @param  int $group_change_id 更改的分组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleStaffGroupUpdate (int $group_change_id) {
        return self::getClass()->handleStaffGroupUpdate([
            "group_change_id" => $group_change_id,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 增加阅读数
     *
     * @param  string $_id id [ require true ]
     * @param  int $staff_num staff_num [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function incrementReadCount (string $_id, int $staff_num) {
        return self::getClass()->incrementReadCount([
            "_id" => $_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 点赞
     *
     * @param  string $_id id [ require true ]
     * @param  int $staff_num staff_num [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function incrementClickCount (string $_id, int $staff_num) {
        return self::getClass()->incrementClickCount([
            "_id" => $_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 取消赞
     *
     * @param  string $_id id [ require true ]
     * @param  int $staff_num staff_num [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function decrementClickCount (string $_id, int $staff_num) {
        return self::getClass()->decrementClickCount([
            "_id" => $_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * isClicked
     *
     * @param  string $_id id [ require true ]
     * @param  int $staff_num staff_num [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function isClicked (string $_id, int $staff_num) {
        return self::getClass()->isClicked([
            "_id" => $_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'PartnerHome\PartnerHomeBroadcast');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'PartnerHome\PartnerHomeBroadcast');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}