<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-06 11:53:52
 */
namespace Mainto\Bridge\Invokes\DataCenter\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ErpActivePage
 */
class ErpActivePage {
    private static string $serviceName = "DataCenter";

    private static string $className = "Erp\\ErpActivePage";

    /**
     * 创建记录
     */
    public static function create (string $category, string $name, string $create_by, string $template, array $extend, string $link, int $number, string $remark, string $state = 'wait_review', string $page_state = 'wait_released') {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["category" => $category, "name" => $name, "create_by" => $create_by, "template" => $template, "extend" => $extend, "link" => $link, "number" => $number, "remark" => $remark, "state" => $state, "page_state" => $page_state, ]);
    }
    /**
     * 列表查询
     */
    public static function getListByPage (int $page_size = 10, int $page = 1, bool $all = false, int $number, string $category, string $name, string $template, string $page_state) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByPage(["page_size" => $page_size, "page" => $page, "all" => $all, "number" => $number, "category" => $category, "name" => $name, "template" => $template, "page_state" => $page_state, ]);
    }
    /**
     * 更新记录
     */
    public static function update (string $_id, string $category, string $name, string $template, int $auditor, array $extend, string $link, string $remark, string $state, string $page_state) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["_id" => $_id, "category" => $category, "name" => $name, "template" => $template, "auditor" => $auditor, "extend" => $extend, "link" => $link, "remark" => $remark, "state" => $state, "page_state" => $page_state, ]);
    }
    /**
     * 删除记录
     */
    public static function delete (string $_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["_id" => $_id, ]);
    }
    /**
     * 获取单条详情
     */
    public static function getInfo (string $_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getInfo(["_id" => $_id, ]);
    }
    /**
     * 用户领券记录
     */
    public static function receiveCoupon (string $activity_id, int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveCoupon(["activity_id" => $activity_id, "user_id" => $user_id, ]);
    }
    /**
     * 查询用户领券记录
     */
    public static function searchRecord (int $page = 1, int $page_size = 10, bool $all = false, string $activity_id, int $user_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchRecord(["page" => $page, "page_size" => $page_size, "all" => $all, "activity_id" => $activity_id, "user_id" => $user_id, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}