<?php
namespace Mainto\Bridge\Invokes\DataCenter\HimoProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createSharePhotoAlbumRecordByParams(array $params)
 * @method updateSharePhotoAlbumRecordByParams(array $params)
 * @method saveSharePhotoAlbumByParams(array $params)
 * @method shareAlbumRecordDetailByParams(array $params)
 * @method getShareAlbumRecordListByParams(array $params)
 * @method sharePhotoAlbumListByParams(array $params)
 * @method deleteSharePhotoAlbumByParams(array $params)
 */
class SharePhotoAlbum {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建相册分享记录
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  array $photos 图片数据 [ require true ]
     * @support  int $share_type 共享类型，1为普通共享，2为指定共享 [ require false ]
     * @support  array $white_phones 手机号白名单数组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSharePhotoAlbumRecord () {
        return self::getClass()->createSharePhotoAlbumRecord([
        ]);
    }

    /**
     * 更新相册分享记录.回调
     *
     * @support  string $share_record_id 分享记录id [ require true ]
     * @support  int $share_type 共享类型，1为普通共享，2为指定共享 [ require true ]
     * @support  array $white_phones 手机号白名单数组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateSharePhotoAlbumRecord () {
        return self::getClass()->updateSharePhotoAlbumRecord([
        ]);
    }

    /**
     * 创建好友共享相册
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  string $reserve_time 订单签到时间 [ require true ]
     * @support  string $share_record_id 分享记录id [ require true ]
     * @support  int $user_id 接受分享者id [ require true ]
     * @support  int $share_user_id 分享者id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveSharePhotoAlbum () {
        return self::getClass()->saveSharePhotoAlbum([
        ]);
    }

    /**
     * 分享相册记录详情
     *
     * @support  string $share_record_id 好友分享记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function shareAlbumRecordDetail () {
        return self::getClass()->shareAlbumRecordDetail([
        ]);
    }

    /**
     * 分享相册记录列表
     *
     * @support  string $order_num 订单号 [ require false ]
     * @support  int $share_type 分享类型，2 为指定分享 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 条目数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShareAlbumRecordList () {
        return self::getClass()->getShareAlbumRecordList([
        ]);
    }

    /**
     * 好友分享相册列表
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  string $reserve_time_start 预约开始时间 [ require false ]
     * @support  string $reserve_time_end 预约结束时间 [ require false ]
     * @support  string $reserve_time_sort 预约时间排序 [ require false ]
     * @support  string $created_at_start 开始分享时间 [ require false ]
     * @support  string $created_at_end 结束分享时间 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 分页数 [ require false ]
     * @support  string $order_num 订单编号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sharePhotoAlbumList () {
        return self::getClass()->sharePhotoAlbumList([
        ]);
    }

    /**
     * 删除分享照片
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  string $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteSharePhotoAlbum () {
        return self::getClass()->deleteSharePhotoAlbum([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'HimoProduct\SharePhotoAlbum');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'HimoProduct\SharePhotoAlbum');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}