<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchCreateByParams(array $params)
 * @method createByParams(array $params)
 * @method searchByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteStoreDepositByParams(array $params)
 * @method getOtherStoresByParams(array $params)
 * @method getTypesByParams(array $params)
 */
class Deposit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量录入
     *
     * @support  array $data 数据 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate();
    }

    /**
     * 单个录入
     *
     * @support  string $number 编号 [ require true ]
     * @support  string $type 保证金类型 [ require true ]
     * @support  string $store 乙方门店 [ require true ]
     * @support  string $region 乙方区域 [ require true ]
     * @support  string $company 乙方单位 [ require true ]
     * @support  string $pay_date 打款时间 require false
     * @support  float $money 金额 [ require true ]
     * @support  string $img 图片地址 require false
     * @support  string $remark 备注 require false
     * @support  string $ticket 是否有票据（not_exist-无 exist-有） [ require true ]
     * @support  bool $other_store 是否是其他门店 [ require true ]
     * @support  int $create_user 操作人 [ require true ]
     * @support  string $state 状态位 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 查询
     *
     * @support  string $state 状态（wait_use-待领用 using-领用中 used-已领用） require false
     * @support  string $store 门店 require false
     * @support  string $pay_date 打款时间 require false
     * @support  string $use_date 领用时间 require false
     * @support  string $refund_date 收到退款时间 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @support  string $number 编号 require false
     * @support  float $money 金额 require false
     * @support  string $ticket 是否有票据（not_exist-无 exist-有） require false
     * @support  string $state 状态 require false
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function search (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->search([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 获取详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 编辑
     *
     * @param  string $_id id [ require true ]
     * @support  string $number 编号 require false
     * @support  string $type 保证金类型 require false
     * @support  string $store 乙方门店 require false
     * @support  string $region 乙方区域 require false
     * @support  string $company 乙方单位 require false
     * @support  string $pay_date 打款时间 require false
     * @support  float $money 金额 require false
     * @support  string $img 图片地址 require false
     * @support  string $remark 备注 require false
     * @support  string $ticket 是否有票据（not_exist-无 exist-有） require false
     * @support  bool $other_store 是否是其他门店 require false
     * @support  int $create_user 操作人 require false
     * @support  string $state 状态位 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 删除
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteStoreDeposit (string $_id) {
        return self::getClass()->deleteStoreDeposit([
            "_id" => $_id,
        ]);
    }

    /**
     * 获取其他门店
     *
     * @param  string $query 搜索条件 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOtherStores (string $query = '') {
        return self::getClass()->getOtherStores([
            "query" => $query,
        ]);
    }

    /**
     * 类型
     *
     * @param  string $query 条件 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTypes (string $query = '') {
        return self::getClass()->getTypes([
            "query" => $query,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\Deposit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\Deposit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}