<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listByParams(array $params)
 */
class RetailShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售产品购物车记录
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 删除零售产品购物车记录
     *
     * @support  array $ids 零售产品sku ids [ require true ]
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 获取零售产品购物车列表
     *
     * @support  int $user_id 用户ID [ require true ]
     * @support  int $city_id 城市ID [ require true ]
     * @support  array $module 模块 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\RetailShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\RetailShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}