<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method searchByParams(array $params)
 * @method updateByParams(array $params)
 * @method infoByParams(array $params)
 * @method getModelByParams(array $params)
 */
class RefundApply {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增
     *
     * @param  string $order_num 订单号 [ require true ]
     * @support  string $reason 退款原因 [ require true ]
     * @support  int $user_id 用户id [ require true ]
     * @support  string $priority 退款优先级 [ require true ]
     * @support  int $applicant 申请人 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  string $state 退款状态 [ require false ]
     * @support  string $apply_date 申请日期 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $order_num) {
        return self::getClass()->create([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 查询
     *
     * @support  array $order_num 订单号 [ require false ]
     * @support  string $priority 优先级 [ require false ]
     * @support  string $apply_date 申请日期 [ require false ]
     * @support  string $state 退款状态 [ require false ]
     * @support  int $user_id 用户id [ require false ]
     * @support  int $store_id 门店id [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页显示数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function search (int $page = 1, int $page_size = 10) {
        return self::getClass()->search([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 更新
     *
     * @param  string $_id 退款申请id [ require true ]
     * @support  string $reason 退款原因 [ require false ]
     * @support  string $priority 退款优先级 [ require false ]
     * @support  int $applicant 申请人 [ require false ]
     * @support  int $handler 处理者 [ require false ]
     * @support  string $state 退款状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 退款申请详情
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function info (string $order_num) {
        return self::getClass()->info([
            "order_num" => $order_num,
        ]);
    }

    /**
     * getModel
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getModel () {
        return self::getClass()->getModel();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\RefundApply');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\RefundApply');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}