<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getListByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method updateByParams(array $params)
 * @method batchTagByParams(array $params)
 * @method deleteByParams(array $params)
 */
class HimoFeedback {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $question_id 问题id [ require true ]
     * @support  string $user_state 用户选项 [ require true ]
     * @support  array $reason 原因标签 [ require false ]
     * @support  string $remark 原因备注 [ require false ]
     * @support  string $phone 联系手机 [ require false ]
     * @param  string $token 用户操作标识 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $token) {
        return self::getClass()->create([
            "token" => $token,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  string $title 标题 [ require false ]
     * @support  string $user_state 用户选项 [ require false ]
     * @support  string $reason 原因标签 [ require false ]
     * @support  string $tag 标记 [ require false ]
     * @support  string $created_at_start 提交日期起 [ require false ]
     * @support  string $created_at_end 提交日期止 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 每页数量 [ require false ]
     * @param  bool $all 是否返回所有结果 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->getList([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  string $_id id [ require true ]
     * @support  string $tag 标记 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 批量标记已处理
     *
     * @support  string $title 标题 [ require false ]
     * @support  string $user_state 用户选项 [ require false ]
     * @support  string $reason 原因标签 [ require false ]
     * @support  string $created_at_start 提交日期起 [ require false ]
     * @support  string $created_at_end 提交日期止 [ require false ]
     * @param  string $tag 标记 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchTag (string $tag = 'handled') {
        return self::getClass()->batchTag([
            "tag" => $tag,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\HimoFeedback');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\HimoFeedback');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}