<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateByParams(array $params)
 * @method deletePackagesOrGroupsByParams(array $params)
 */
class ShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  array $products 购物车产品集合 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  int $user_id 用户ID [ require true ]
     * @support  int $city_id 城市id [ require true ]
     * @support  array $module 模块 [ require false ]
     * @support  int $id 产品id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList([
        ]);
    }

    /**
     * 删除记录
     *
     * @support  array $_ids ids [ require true ]
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 更新购物车所选产品
     *
     * @support  array $products 产品 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 根据套餐或产品组删除购物车
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  string $module 所属模块 [ require true ]
     * @support  array $package_ids 套餐ids [ require false ]
     * @support  array $product_group_ids 产品组ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deletePackagesOrGroups () {
        return self::getClass()->deletePackagesOrGroups([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\ShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\ShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}