<?php
namespace Mainto\Bridge\Invokes\DataCenter\PartnerHome;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method createAllByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method doneByParams(array $params)
 * @method getScoreSumByIdsByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getCountsByParams(array $params)
 */
class PartnerHomeData {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $state 状态位 [ require true ]
     * @support  int $staff_num 工号 [ require true ]
     * @support  string $from 数据来源 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @support  string $from_id 数据来源的id require false
     * @support  int $score 愿望值数量 [ require true ]
     * @support  string $tag 事件名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 创建记录批量
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createAll (array $data) {
        return self::getClass()->createAll([
            "data" => $data,
        ]);
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  string $state 状态位 require false
     * @support  int $staff_num 工号 require false
     * @support  string $from 数据来源 require false
     * @support  string $type 类型 require false
     * @support  string $from_id 数据来源的id require false
     * @support  int $score 愿望值数量 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByPage (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->getListByPage([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 设置数据为已领取
     *
     * @param  array $_ids id [ require true ]
     * @param  int $total_score 总分值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function done (array $_ids, int $total_score) {
        return self::getClass()->done([
            "_ids" => $_ids,
            "total_score" => $total_score,
        ]);
    }

    /**
     * 获取每个id对应产生的分值总和
     *
     * @param  array $from_ids from_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getScoreSumByIds (array $from_ids = []) {
        return self::getClass()->getScoreSumByIds([
            "from_ids" => $from_ids,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  array $_ids id [ require true ]
     * @support  string $state 状态位 require false
     * @support  int $staff_num 工号 require false
     * @support  string $from 数据来源 require false
     * @support  string $type 类型 require false
     * @support  string $from_id 数据来源的id require false
     * @support  int $score 愿望值数量 require false
     * @support  string $done_at 时间 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (array $_ids) {
        return self::getClass()->update([
            "_ids" => $_ids,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 按条件统计
     *
     * @support  int $staff_num 工号 require false
     * @support  string $type 类型 require false
     * @support  string $state 状态位 require false
     * @param  string $groupBy groupBy [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCounts (string $groupBy = '') {
        return self::getClass()->getCounts([
            "groupBy" => $groupBy,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'PartnerHome\PartnerHomeData');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'PartnerHome\PartnerHomeData');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}