<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateByParams(array $params)
 * @method bannerModuleMapByParams(array $params)
 * @method bannerTreeByParams(array $params)
 */
class HimoBanner {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $title 标题 [ require false ]
     * @support  array $except_city 不展示的城市 [ require false ]
     * @support  array $limit_city 仅限城市 [ require false ]
     * @support  string $img_path 图片地址 [ require true ]
     * @support  string $url 跳转地址 [ require false ]
     * @support  int $sequence 序号 [ require false ]
     * @support  string $start 上线时间 [ require false ]
     * @support  string $end 下线时间 [ require false ]
     * @support  string $module 品牌 [ require false ]
     * @support  string $sub_module 子品牌 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 获取记录列表
     *
     * @param  int $current_city 当前城市id [ require false ]
     * @param  string $module 所属品牌 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList (int $current_city = null, string $module = '') {
        return self::getClass()->getList([
            "current_city" => $current_city,
            "module" => $module,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  string $_id id [ require true ]
     * @support  string $title 标题 [ require false ]
     * @support  array $except_city 不展示的城市 [ require false ]
     * @support  array $limit_city 仅限城市 [ require false ]
     * @support  string $img_path 图片地址 [ require false ]
     * @support  string $url 跳转地址 [ require false ]
     * @support  int $sequence 序号 [ require false ]
     * @support  string $start 上线时间 [ require false ]
     * @support  string $end 下线时间 [ require false ]
     * @support  string $module 品牌 [ require false ]
     * @support  string $sub_module 子品牌 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * get-bannerModuleMap
     *
     * @throws  \Exception
     * @return  array
     */
    public static function bannerModuleMap () {
        return self::getClass()->bannerModuleMap();
    }

    /**
     * get-bannerTree
     *
     * @throws  \Exception
     * @return  array
     */
    public static function bannerTree () {
        return self::getClass()->bannerTree();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\HimoBanner');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\HimoBanner');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}