<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method searchByParams(array $params)
 * @method getModelByParams(array $params)
 */
class Rental {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店租金缴费录入
     *
     * @support  int $store_id 门店编号 [ require true ]
     * @support  string $contract_start_at 合同开始日期 [ require false ]
     * @support  string $contract_end_at 合同结束日期 [ require false ]
     * @support  int $apply_time 最晚申请时间 [ require false ]
     * @support  array $fixed_rent 固定租金 [ require false ]
     * @support  array $property 物业费 [ require false ]
     * @support  array $promotion 推广费 [ require false ]
     * @support  array $trash_cleanup 垃圾清理费 [ require false ]
     * @support  array $pos_rent pos租金 [ require false ]
     * @support  array $more 其他费用 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 更新
     *
     * @param  string $_id 合同id [ require true ]
     * @support  string $contract_start_at 合同开始日期 [ require false ]
     * @support  string $contract_end_at 合同结束日期 [ require false ]
     * @support  int $apply_time 最晚申请时间 [ require false ]
     * @support  array $fixed_rent 固定租金 [ require false ]
     * @support  array $property 物业费 [ require false ]
     * @support  array $promotion 推广费 [ require false ]
     * @support  array $trash_cleanup 垃圾清理费 [ require false ]
     * @support  array $pos_rent pos租金 [ require false ]
     * @support  array $more 其他费用 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 查询
     *
     * @support  array $store_id 门店ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function search () {
        return self::getClass()->search([
        ]);
    }

    /**
     * getModel
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getModel () {
        return self::getClass()->getModel();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\Rental');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\Rental');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}