<?php
namespace Mainto\Bridge\Invokes\DataCenter\HimoAppointmentPlatform;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getHistoryByParams(array $params)
 * @method delHistoryRecordByParams(array $params)
 */
class SearchHistory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加搜索历史
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $content 搜索内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取搜索历史
     *
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHistory () {
        return self::getClass()->getHistory();
    }

    /**
     * 删除搜索历史记录
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $id 记录id require false
     * @throws  \Exception
     * @return  bool
     */
    public static function delHistoryRecord () {
        return self::getClass()->delHistoryRecord();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'HimoAppointmentPlatform\SearchHistory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'HimoAppointmentPlatform\SearchHistory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}