<?php
namespace Mainto\Bridge\Invokes\DataCenter;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method editByParams(array $params)
 * @method getMetaConfigByParams(array $params)
 * @method hasByParams(array $params)
 * @method renameByParams(array $params)
 * @method deleteByParams(array $params)
 * @method countByParams(array $params)
 */
class Meta {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $config 配置 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, array $config = []) {
        return self::getClass()->create([
            "name" => $name,
            "config" => $config,
        ]);
    }

    /**
     * 修改
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $config 配置 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit (string $name, array $config = []) {
        return self::getClass()->edit([
            "name" => $name,
            "config" => $config,
        ]);
    }

    /**
     * 获取配置
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMetaConfig (string $name) {
        return self::getClass()->getMetaConfig([
            "name" => $name,
        ]);
    }

    /**
     * 检查池是否存在
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function has (string $name) {
        return self::getClass()->has([
            "name" => $name,
        ]);
    }

    /**
     * 更名池
     *
     * @param  string $oldName 更改前名称 [ require true ]
     * @param  string $newName 更改后名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function rename (string $oldName, string $newName) {
        return self::getClass()->rename([
            "oldName" => $oldName,
            "newName" => $newName,
        ]);
    }

    /**
     * 删除池
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $name) {
        return self::getClass()->delete([
            "name" => $name,
        ]);
    }

    /**
     * 计算meta个数
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function count (string $name) {
        return self::getClass()->count([
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Meta');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Meta');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}