<?php
namespace Mainto\Bridge\Invokes\DataCenter;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addItemByParams(array $params)
 * @method updateItemByParams(array $params)
 * @method mergeItemByParams(array $params)
 * @method findItemByParams(array $params)
 * @method deleteItemByParams(array $params)
 */
class Collection {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 插入一条
     *
     * @param  string $name 要插入到的池名称 [ require true ]
     * @param  int $id 项目ID [Original type uint] [ require true ]
     * @param  array $item 项目信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addItem (string $name, int $id, array $item) {
        return self::getClass()->addItem([
            "name" => $name,
            "id" => $id,
            "item" => $item,
        ]);
    }

    /**
     * 更新信息
     *
     * @param  string $name 池名称 [ require true ]
     * @param  int $id 项目ID [Original type uint] [ require true ]
     * @param  array $item 项目信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateItem (string $name, int $id, array $item) {
        return self::getClass()->updateItem([
            "name" => $name,
            "id" => $id,
            "item" => $item,
        ]);
    }

    /**
     * 合并信息
     *
     * @param  string $name 池名称 [ require true ]
     * @param  int $id 项目ID [Original type uint] [ require true ]
     * @param  array $item 项目信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function mergeItem (string $name, int $id, array $item) {
        return self::getClass()->mergeItem([
            "name" => $name,
            "id" => $id,
            "item" => $item,
        ]);
    }

    /**
     * 读取信息
     *
     * @param  string $name 池名称 [ require true ]
     * @param  int $id 项目ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function findItem (string $name, int $id) {
        return self::getClass()->findItem([
            "name" => $name,
            "id" => $id,
        ]);
    }

    /**
     * 移除信息
     *
     * @param  string $name 池名称 [ require true ]
     * @param  int $id 项目ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteItem (string $name, int $id) {
        return self::getClass()->deleteItem([
            "name" => $name,
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Collection');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Collection');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}