<?php
namespace Mainto\Bridge\Invokes\DataCenter\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method receiveCouponByParams(array $params)
 * @method searchRecordByParams(array $params)
 */
class ErpActivePage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $category 分类 [ require true ]
     * @support  string $name 活动名称 [ require true ]
     * @support  string $create_by 创建者 [ require true ]
     * @support  string $template 模板key [ require true ]
     * @support  array $extend 扩展信息 [ require true ]
     * @support  string $link 活动页面链接 [ require true ]
     * @support  int $number 活动编号 [ require true ]
     * @support  string $remark 备注 
     * @support  string $state 状态 
     * @support  string $page_state 页面状态 
     * @throws  \Exception
     * @return  string
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 列表查询
     *
     * @support  int $number 活动编号 
     * @support  string $category 分类 
     * @support  string $name 活动名称 
     * @support  string $template 模板key 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @support  string $page_state 页面状态 
     * @throws  \Exception
     * @return  array
     */
    public static function getListByPage (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->getListByPage([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  string $_id id [ require true ]
     * @support  string $category 分类 
     * @support  string $name 活动名称 
     * @support  string $template 模板key 
     * @support  int $auditor 审核者 
     * @support  array $extend 扩展信息 
     * @support  string $link 活动页面链接 
     * @support  string $remark 备注 
     * @support  string $state 状态 
     * @support  string $page_state 页面状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 用户领券记录
     *
     * @param  string $activity_id 活动id [ require true ]
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveCoupon (string $activity_id, int $user_id) {
        return self::getClass()->receiveCoupon([
            "activity_id" => $activity_id,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 查询用户领券记录
     *
     * @support  string $activity_id 活动id [ require true ]
     * @support  int $user_id 用户id 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchRecord (int $page = 1, int $page_size = 10, bool $all = false) {
        return self::getClass()->searchRecord([
            "page" => $page,
            "page_size" => $page_size,
            "all" => $all,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Erp\ErpActivePage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Erp\ErpActivePage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}