<?php
namespace Mainto\Bridge\Invokes\DataCenter\HimoProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addCompanyShootRequirementByParams(array $params)
 * @method companyShootRequirementListByParams(array $params)
 */
class CompanyShootRequirement {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建企业拍摄请求
     *
     * @support  string $open_id 微信openid [ require true ]
     * @support  string $contract_name 联系人姓名 [ require true ]
     * @support  int $contract_phone 联系人手机号 [ require true ]
     * @support  string $company_name 企业名称 [ require true ]
     * @support  string $detail 拍摄需求描述 
     * @support  string $shoot_people_num_type 拍摄人数类型A:0-30,B:30-100,C:100人以上 [ require true ]
     * @support  int $shoot_city_id 拍摄城市id [ require true ]
     * @support  int $shoot_store_id 拍摄门店id 
     * @support  string $user_ip 用户ip 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addCompanyShootRequirement () {
        return self::getClass()->addCompanyShootRequirement();
    }

    /**
     * 企业拍摄请求列表
     *
     * @support  string $open_id 微信openid 
     * @support  string $user_ip 用户ip地址 
     * @support  int $page 页数 
     * @support  int $page_size 条目数 
     * @support  string $create_at_sort 创建时间排序,默认desc 
     * @throws  \Exception
     * @return  array
     */
    public static function companyShootRequirementList () {
        return self::getClass()->companyShootRequirementList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'HimoProduct\CompanyShootRequirement');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'HimoProduct\CompanyShootRequirement');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}