<?php
namespace Mainto\Bridge\Invokes\DataCenter\Retail;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method getListByParams(array $params)
 * @method getCountByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updatesByParams(array $params)
 */
class RetailShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量创建记录
     *
     * @support  array $products 购物车产品集合 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取单条详情
     *
     * @param  string $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $id) {
        return self::getClass()->getInfo([
            "id" => $id,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  int $user_id 用户ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 获取用创建条数
     *
     * @support  int $user_id 用户ID [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getCount () {
        return self::getClass()->getCount();
    }

    /**
     * 删除记录
     *
     * @support  array $ids 需要删除ids [ require true ]
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 批量更新购物车所选产品
     *
     * @support  array $products 产品 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updates () {
        return self::getClass()->updates();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Retail\RetailShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Retail\RetailShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}