<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method searchByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getModelByParams(array $params)
 */
class PerformanceTarget {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 导入
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (array $data) {
        return self::getClass()->create([
            "data" => $data,
        ]);
    }

    /**
     * 更新
     *
     * @param  string $_id 绩效目标id [ require true ]
     * @param  string $target 目标 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id, string $target) {
        return self::getClass()->update([
            "_id" => $_id,
            "target" => $target,
        ]);
    }

    /**
     * 查询
     *
     * @support  string $month 日期 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页显示数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function search (int $page = 1, int $pageSize = 10) {
        return self::getClass()->search([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除
     *
     * @param  string $month 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $month) {
        return self::getClass()->delete([
            "month" => $month,
        ]);
    }

    /**
     * get model
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getModel () {
        return self::getClass()->getModel();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\PerformanceTarget');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\PerformanceTarget');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}