<?php
namespace Mainto\Bridge\Invokes\DataCenter\Lens;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method exportByParams(array $params)
 * @method captchaByParams(array $params)
 */
class LensSignUp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 我要报名
     *
     * @support  string $name 姓名 [ require true ]
     * @support  string $mobile 电话 [ require true ]
     * @support  string $lesson 课程 [ require true ]
     * @support  string $city 城市 [ require true ]
     * @support  string $captcha 验证码 
     * @throws  \Exception
     * @return  string
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 报名导出
     *
     * @support  string $name 姓名 
     * @support  string $mobile 电话 
     * @support  string $lesson 课程 
     * @support  string $city 城市 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function export (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->export([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 获取验证码
     *
     * @support  string $mobile 电话 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function captcha () {
        return self::getClass()->captcha();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Lens\LensSignUp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Lens\LensSignUp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}