<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method inboundingByParams(array $params)
 * @method inboundedByParams(array $params)
 * @method allocatingByParams(array $params)
 * @method allocatedByParams(array $params)
 * @method damagingByParams(array $params)
 * @method damagedByParams(array $params)
 * @method receivingByParams(array $params)
 * @method receivedByParams(array $params)
 * @method sellingByParams(array $params)
 * @method soldByParams(array $params)
 * @method getStockPlacesByParams(array $params)
 * @method getLogListByParams(array $params)
 * @method getStockListByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 入库 (返回入库log_id)
     *
     * @support  string $stock_place 库存地 [ require true ]
     * @support  int $product_id 商品id [ require true ]
     * @support  int $counts 入库数量 [ require true ]
     * @support  float $price 单价 [Original type double] [ require true ]
     * @support  string $supplier 供应商 
     * @support  string $apply_remark 申请备注 
     * @support  int $applicant 申请人 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function inbounding () {
        return self::getClass()->inbounding();
    }

    /**
     * 确认入库
     *
     * @param  string $stock_place 库存地 [ require true ]
     * @param  string $log_id 记录id [ require true ]
     * @support  string $audit_remark 审核备注 
     * @support  int $auditor 审核人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function inbounded (string $stock_place, string $log_id) {
        return self::getClass()->inbounded([
            "stock_place" => $stock_place,
            "log_id" => $log_id,
        ]);
    }

    /**
     * 调配
     *
     * @support  string $stock_place 库存地 [ require true ]
     * @support  int $product_id 产品id [ require true ]
     * @support  int $counts 调配数量 [ require true ]
     * @support  array $asset_numbers 调配编号 
     * @support  string $allocation_to 调配至 [ require true ]
     * @support  string $apply_remark 申请备注 
     * @support  int $applicant 申请人 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function allocating () {
        return self::getClass()->allocating();
    }

    /**
     * 确认调配
     *
     * @param  string $stock_place 库存地 [ require true ]
     * @param  string $log_id 记录id [ require true ]
     * @support  string $audit_remark 审核备注 
     * @support  int $auditor 审核人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function allocated (string $stock_place, string $log_id) {
        return self::getClass()->allocated([
            "stock_place" => $stock_place,
            "log_id" => $log_id,
        ]);
    }

    /**
     * 报损
     *
     * @support  string $stock_place 库存地 [ require true ]
     * @support  int $product_id 记录id [ require true ]
     * @support  int $counts 报损数量 [ require true ]
     * @support  array $asset_numbers 报损编号 
     * @support  string $apply_remark 申请备注 
     * @support  int $applicant 申请人 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function damaging () {
        return self::getClass()->damaging();
    }

    /**
     * 确认报损
     *
     * @param  string $stock_place 库存地 [ require true ]
     * @param  string $log_id 记录id [ require true ]
     * @support  string $audit_remark 审核备注 
     * @support  int $auditor 审核人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function damaged (string $stock_place, string $log_id) {
        return self::getClass()->damaged([
            "stock_place" => $stock_place,
            "log_id" => $log_id,
        ]);
    }

    /**
     * 领用
     *
     * @support  string $stock_place 库存地 [ require true ]
     * @support  int $product_id 记录id [ require true ]
     * @support  int $counts 领用数量 [ require true ]
     * @support  string $asset_numbers 资产编号 
     * @support  string $department 领用部门 [ require true ]
     * @support  string $receiver 领用人 [ require true ]
     * @support  string $apply_remark 申请备注 
     * @support  int $applicant 申请人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiving () {
        return self::getClass()->receiving();
    }

    /**
     * 确认领用
     *
     * @param  string $stock_place 库存地 [ require true ]
     * @param  string $log_id 记录id [ require true ]
     * @support  string $audit_remark 审核备注 
     * @support  int $auditor 审核人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function received (string $stock_place, string $log_id) {
        return self::getClass()->received([
            "stock_place" => $stock_place,
            "log_id" => $log_id,
        ]);
    }

    /**
     * 售卖出库
     *
     * @support  string $stock_place 库存地 [ require true ]
     * @support  int $product_id 产品id [ require true ]
     * @support  int $counts 领用数量 [ require true ]
     * @support  string $asset_numbers 资产编号 
     * @support  string $apply_remark 申请备注 
     * @support  int $applicant 申请人 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function selling () {
        return self::getClass()->selling();
    }

    /**
     * 确认售卖
     *
     * @param  string $stock_place 库存地 [ require true ]
     * @param  string $log_id 记录id [ require true ]
     * @support  string $audit_remark 审核备注 
     * @support  int $auditor 审核人 
     * @throws  \Exception
     * @return  mixed
     */
    public static function sold (string $stock_place, string $log_id) {
        return self::getClass()->sold([
            "stock_place" => $stock_place,
            "log_id" => $log_id,
        ]);
    }

    /**
     * 获取所有库存地
     *
     * @support  array $stock_places 库存地 
     * @throws  \Exception
     * @return  array
     */
    public static function getStockPlaces () {
        return self::getClass()->getStockPlaces();
    }

    /**
     * 获取流动信息
     *
     * @support  string $stock_place 库存地 
     * @support  array $product_id 产品id数组 
     * @support  string $created_at_start 操作时间起 
     * @support  string $created_at_end 操作时间止 
     * @support  string $type 操作类型 
     * @support  string $handle 是否已处理 
     * @param  int $page_size 每页条数 [ require true ]
     * @param  int $page 第n页 [ require true ]
     * @param  bool $all 是否显示所有 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLogList (bool $all = false, int $page_size = 10, int $page = 1) {
        return self::getClass()->getLogList([
            "all" => $all,
            "page_size" => $page_size,
            "page" => $page,
        ]);
    }

    /**
     * 获取库存信息(不传库存地时, 不进行分页，且只查询一个product_id信息)
     *
     * @support  string $stock_place 库存地 
     * @support  array $product_id 产品id数组 [Original type array&lt;int&gt;] 
     * @param  int $page_size 每页条数 [ require true ]
     * @param  int $page 第n页 [ require true ]
     * @support  bool $all 是否显示所有 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStockList (int $page = 1, int $page_size = 10) {
        return self::getClass()->getStockList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}