<?php
namespace Mainto\Bridge\Invokes\DataCenter\HimoProduct;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createChristmasActivityRecordByParams(array $params)
 * @method updateChristmasActivityRecordByParams(array $params)
 * @method getChristmasActivityRecordByIdByParams(array $params)
 * @method getChristmasActivityRecordByUserIdByParams(array $params)
 * @method deleteChristmasActivityRecordByIdByParams(array $params)
 * @method getChristmasUserJoinRecordByUserIdOrActivityIdByParams(array $params)
 * @method updateChristmasUserJoinPhotoByHeaderOrderNumByParams(array $params)
 * @method updateChristmasUserJoinPhotoBySteamNumByParams(array $params)
 * @method updateChristmasUserJoinStreamNumByActivityIdByParams(array $params)
 */
class ChristmasActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建活动记录
     *
     * @support  string $header_order_num 订单号 [ require true ]
     * @support  int $header_user_id 团长用户id [ require true ]
     * @support  string $type 成团类型 [ require true ]
     * @support  int $people_num 成团人数 [ require true ]
     * @support  string $status 成团状态 [ require true ]
     * @support  array $member_info 成团信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createChristmasActivityRecord () {
        return self::getClass()->createChristmasActivityRecord();
    }

    /**
     * 更新活动记录
     *
     * @support  string $activity_id 活动id [ require true ]
     * @support  string $header_order_num 订单号 
     * @support  int $header_user_id 团长用户id 
     * @support  int $people_num 成团人数 
     * @support  string $status 成团状态 
     * @support  array $member_info 成团信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateChristmasActivityRecord () {
        return self::getClass()->updateChristmasActivityRecord();
    }

    /**
     * 通过活动id获取活动记录
     *
     * @support  string $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getChristmasActivityRecordById () {
        return self::getClass()->getChristmasActivityRecordById();
    }

    /**
     * 通过用户id获取活动记录
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getChristmasActivityRecordByUserId () {
        return self::getClass()->getChristmasActivityRecordByUserId();
    }

    /**
     * 按id删除获得记录
     *
     * @support  string $activity_id 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteChristmasActivityRecordById () {
        return self::getClass()->deleteChristmasActivityRecordById();
    }

    /**
     * 通过用户id或活动id获取用户参团记录
     *
     * @support  int $user_id 用户id 
     * @support  string $activity_id 活动id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getChristmasUserJoinRecordByUserIdOrActivityId () {
        return self::getClass()->getChristmasUserJoinRecordByUserIdOrActivityId();
    }

    /**
     * 更新用户成团图片.按团长订单号
     *
     * @support  string $header_order_num 团长的订单号 [ require true ]
     * @support  string $completed_photo 成团照url [ require true ]
     * @support  string $type 成团类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateChristmasUserJoinPhotoByHeaderOrderNum () {
        return self::getClass()->updateChristmasUserJoinPhotoByHeaderOrderNum();
    }

    /**
     * 更新用户成团图片.按图片流水号
     *
     * @support  string $stream_num 图片流水号 [ require true ]
     * @support  string $completed_photo 成团照url [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateChristmasUserJoinPhotoBySteamNum () {
        return self::getClass()->updateChristmasUserJoinPhotoBySteamNum();
    }

    /**
     * 按活动id更新stream_num
     *
     * @support  string $activity_id 活动id [ require true ]
     * @support  string $stream_num 图片流水号，做更新图片使用 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function updateChristmasUserJoinStreamNumByActivityId () {
        return self::getClass()->updateChristmasUserJoinStreamNumByActivityId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'HimoProduct\ChristmasActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'HimoProduct\ChristmasActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}