<?php
namespace Mainto\Bridge\Invokes\DataCenter\Mantu;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method successReserveByParams(array $params)
 * @method searchByParams(array $params)
 * @method createStaffNoteByParams(array $params)
 */
class CustomerReserve {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建客资
     *
     * @support  string $reserve_time 顾客预约时间段 [ require true ]
     * @support  string $phone 手机号 
     * @support  string $wechat 微信号 
     * @support  string $note 备注 
     * @support  string $status 状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 标记处理客资
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function successReserve (string $_id) {
        return self::getClass()->successReserve([
            "_id" => $_id,
        ]);
    }

    /**
     * 列表
     *
     * @support  string $status 状态（wait-待处理 success-已处理) 
     * @support  string $phone 手机号 
     * @support  string $reserve_time 顾客预约时间段 
     * @support  string $created_at_start 创建时间起 
     * @support  string $created_at_end 创建时间止 
     * @support  int $page 页码 
     * @support  int $page_size 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function search () {
        return self::getClass()->search();
    }

    /**
     * 添加员工备注
     *
     * @param  string $_id id [ require true ]
     * @param  string $staff_note 员工备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStaffNote (string $staff_note, string $_id) {
        return self::getClass()->createStaffNote([
            "staff_note" => $staff_note,
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Mantu\CustomerReserve');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Mantu\CustomerReserve');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}