<?php
namespace Mainto\Bridge\Invokes\DataCenter\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method receiveByParams(array $params)
 * @method searchByParams(array $params)
 */
class BusinessActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建券码
     *
     * @support  string $code 活动码 [ require true ]
     * @support  int $channel 渠道号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 用户领取
     *
     * @param  int $channel 渠道号 [Original type uint] [ require true ]
     * @param  int $user_id 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receive (int $channel, int $user_id) {
        return self::getClass()->receive([
            "channel" => $channel,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 查询记录
     *
     * @support  int $user_id 用户ID [Original type uint] 
     * @support  string $status 状态 
     * @support  int $channel 渠道号 [Original type uint] 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页显示数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function search (int $page = 1, int $page_size = 20) {
        return self::getClass()->search([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Himo\BusinessActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Himo\BusinessActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}