<?php
namespace Mainto\Bridge\Invokes\DataCenter;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method searchByParams(array $params)
 * @method contentCreateByParams(array $params)
 * @method updateByParams(array $params)
 */
class ProductTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品模板
     *
     * @support  int $pid 产品id [ require true ]
     * @support  string $template 模板 [ require true ]
     * @support  string $slogan 标语 require false
     * @support  int $isShow 显示 [ require true ]
     * @support  int $sort 排序 require false
     * @support  int $edit 编辑 require false
     * @support  string $smallTemplate 小模板 require false
     * @support  int $maxWord 最大字数 require false
     * @support  int $width 宽 require false
     * @support  int $height 高 require false
     * @support  int $imgWidth 图片宽度 require false
     * @support  int $imgHeight 图片高度 require false
     * @support  int $imgToTop 到顶部 require false
     * @support  int $editToTop 标记到顶部 require false
     * @support  int $editFontSize 编辑字体尺寸 require false
     * @support  int $editLineHeight 编辑线高度 require false
     * @support  string $editAlign 编辑行 require false
     * @support  int $editToLeft 编辑到左 require false
     * @support  int $bigScreen 大屏 require false
     * @support  int $imgToLeft 图片到左距离 require false
     * @support  int $imgRadius 图片半径 require false
     * @support  string $editColor 颜色 require false
     * @support  float $imgRotate 图片旋转度 require false
     * @support  string $maskImg 顶层蒙层图片 require false
     * @support  int $onlySquare 只允许正方形图片 require false
     * @support  int $onlyRectangle 只允许长方形图片 require false
     * @support  int $editRow 文案编辑行数 require false
     * @support  int $imgBorderLeft 图片左边框宽度 require false
     * @support  int $imgBorderRight 图片右边框宽度 require false
     * @support  int $imgBorderTop 图片上边框宽度 require false
     * @support  int $imgBorderBottom 图片下边框宽度 require false
     * @support  string $imgBorderColor 图片边框颜色 require false
     * @support  string $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 查询
     *
     * @param  array $product_ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function search (array $product_ids) {
        return self::getClass()->search([
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 模本内容存储
     *
     * @support  string $product_name 产品名 [ require true ]
     * @support  int $uid 用户id [ require true ]
     * @support  string $content 模板文字内容 [ require true ]
     * @support  string $store_name 门店名 [ require true ]
     * @support  string $reserve_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function contentCreate () {
        return self::getClass()->contentCreate();
    }

    /**
     * 更新产品模板
     *
     * @param  string $_id 模板ID [ require true ]
     * @support  int $pid 产品id require false
     * @support  int $tempGroupId 模板组ID require false
     * @support  string $tempGroupName 模板组名称 require false
     * @support  string $template 模板 require false
     * @support  string $slogan 标语 require false
     * @support  int $isShow 显示 require false
     * @support  int $sort 排序 require false
     * @support  int $edit 编辑 require false
     * @support  string $smallTemplate 小模板 require false
     * @support  int $maxWord 最大字数 require false
     * @support  int $width 宽 require false
     * @support  int $height 高 require false
     * @support  int $imgWidth 图片宽度 require false
     * @support  int $imgHeight 图片高度 require false
     * @support  int $imgToTop 到顶部 require false
     * @support  int $editToTop 标记到顶部 require false
     * @support  int $editFontSize 编辑字体尺寸 require false
     * @support  int $editLineHeight 编辑线高度 require false
     * @support  string $editAlign 编辑行 require false
     * @support  int $editToLeft 编辑到左 require false
     * @support  int $bigScreen 大屏 require false
     * @support  int $imgToLeft 图片到左距离 require false
     * @support  int $imgRadius 图片半径 require false
     * @support  string $editColor 颜色 require false
     * @support  float $imgRotate 图片旋转度 require false
     * @support  string $maskImg 顶层蒙层图片 require false
     * @support  int $onlySquare 只允许正方形图片 require false
     * @support  int $onlyRectangle 只允许长方形图片 require false
     * @support  int $editRow 文案编辑行数 require false
     * @support  int $imgBorderLeft 图片左边框宽度 require false
     * @support  int $imgBorderRight 图片右边框宽度 require false
     * @support  int $imgBorderTop 图片上边框宽度 require false
     * @support  int $imgBorderBottom 图片下边框宽度 require false
     * @support  string $imgBorderColor 图片边框颜色 require false
     * @support  string $extend 扩展信息 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'ProductTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'ProductTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}