<?php
namespace Mainto\Bridge\Invokes\DataCenter\Training;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method readCountPlusByParams(array $params)
 * @method getReadsByParams(array $params)
 * @method getListByPageByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateByParams(array $params)
 */
class TrainingExample {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建记录
     *
     * @support  string $title 标题 [ require true ]
     * @support  int $category_id 分类id [ require true ]
     * @support  array $position_ids 分组 [ require true ]
     * @support  string $origin 来源 [ require true ]
     * @support  array $extend 拓展信息 [ require true ]
     * @support  string $content 内容 [ require true ]
     * @support  int $top 置顶序号 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (string $_id) {
        return self::getClass()->getInfo([
            "_id" => $_id,
        ]);
    }

    /**
     * 获取单条详情
     *
     * @param  string $_id _id [ require true ]
     * @param  int $staff_num staff_num [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function readCountPlus (string $_id, int $staff_num) {
        return self::getClass()->readCountPlus([
            "_id" => $_id,
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 获取阅读数据
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReads (string $_id) {
        return self::getClass()->getReads([
            "_id" => $_id,
        ]);
    }

    /**
     * 列表查询
     *
     * @support  string $title 标题 require false
     * @support  int $category_id 分类id require false
     * @support  array $position_ids 分组 require false
     * @support  string $origin 来源 require false
     * @support  bool $is_released 是否上线 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @param  bool $all 是否返回所有结果 [ require true ]
     * @support  array $order_by 排序 [[&#039;top&#039;, &#039;desc&#039;]] require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByPage (int $page_size = 10, int $page = 1, bool $all = false) {
        return self::getClass()->getListByPage([
            "page_size" => $page_size,
            "page" => $page,
            "all" => $all,
        ]);
    }

    /**
     * 删除记录
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 更新记录
     *
     * @param  string $_id id [ require true ]
     * @support  string $title 标题 require false
     * @support  int $category_id 分类id require false
     * @support  array $position_ids 分组 require false
     * @support  string $origin 来源 require false
     * @support  array $extend 拓展信息 require false
     * @support  string $content 内容 require false
     * @support  bool $is_released 是否上线 require false
     * @support  int $top 置顶序号 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $_id) {
        return self::getClass()->update([
            "_id" => $_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('DataCenter', 'Training\TrainingExample');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('DataCenter', 'Training\TrainingExample');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}